﻿//========================================================================================
//  
//  $File: //depot/indesign_6.0/gm/build/scripts/export as xhtml/startup scripts/XHTMLExportMenuItemLoader.jsx $
//  
//  Owner: Jonathan W. Brown
//  
//  $Author: pmbuilder $
//  
//  $DateTime: 2008/08/18 16:29:43 $
//  
//  $Revision: #1 $
//  
//  $Change: 643585 $
//  
//  Copyright 1997-2007 Adobe Systems Incorporated. All rights reserved.
//  
//  NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance 
//  with the terms of the Adobe license agreement accompanying it.  If you have received
//  this file from a source other than Adobe, then your use, modification, or 
//  distribution of it requires the prior written permission of Adobe.
//
//  Purpose: Load and run the XHTML Export Menu Item script
//
//  The XHTML Export Menu Item script needs to run in a persistent script engine.
//  Binary scripts can't switch to a specfic script engine. Thus we use this
//  uncompiled script to run the XHTML Export Menu Item script in the proper
//  script engine.
//
//==============================================================================

#targetengine "xhtml export"

//Set to true to enable DEBUG code
var DEBUG = false ;

function assert( condition, text ) { if ( DEBUG && !condition ) { alert( text ) ; } }

//Don't want to run twice
if (typeof(XHTMLExportMenuItem) == 'undefined')
{
	//------------------------------------------------------------------------------
	// XHTMLExportMenuItemLoader.constructor
	//------------------------------------------------------------------------------

	function XHTMLExportMenuItemLoader()
	{
	}

	//------------------------------------------------------------------------------
	// XHTMLExportMenuItemLoader.getScriptsFolderPath
	//------------------------------------------------------------------------------

	XHTMLExportMenuItemLoader.getScriptsFolderPath = function()
	{
		try
		{
			var script = app.activeScript;
		}
		catch(e)
		{
			// we are running from the ESTK
			var script = File(e.fileName);
		}
		return script.parent.parent ;	//this file is in the "startup scripts" subfolder
	}


	//------------------------------------------------------------------------------
	// XHTMLExportMenuItemLoader.loadScript
	//------------------------------------------------------------------------------

	XHTMLExportMenuItemLoader.loadScript = function(filename)
	{
		return File(XHTMLExportMenuItemLoader.getScriptsFolderPath() + '/' + filename );
	}

	//------------------------------------------------------------------------------
	// main
	//------------------------------------------------------------------------------

	// load the script
	XHTMLExportMenuItemLoader.script = XHTMLExportMenuItemLoader.loadScript('XHTMLExportMenuItem.jsxbin');
	if ( !XHTMLExportMenuItemLoader.script.exists )
	{
		XHTMLExportMenuItemLoader.script = XHTMLExportMenuItemLoader.loadScript('XHTMLExportMenuItem.jsx');
	}
	// execute it
	assert( XHTMLExportMenuItemLoader.script.exists, "XHTMLExportMenuItem.jsx* missing; load failed" ) ;
	if ( XHTMLExportMenuItemLoader.script.exists )
	{
		var cacheCurrent = Folder.current ;
		try
		{
			Folder.current = XHTMLExportMenuItemLoader.getScriptsFolderPath();
			app.doScript(XHTMLExportMenuItemLoader.script);
		}
		finally
		{
			Folder.current = cacheCurrent ;
		}
	}
}
